<?php

require_once('SSHCommand.php');
require_once('DatabaseConfigManager.php');

class MasterModeConfiguration
{
    protected $_db_cfg_mgr = null;

    const MASTER_SWITCHABLE_DISABLE = "0";
    const MASTER_SWITCHABLE_ENABLE = "1";
    const MASTER_MODE_ENABLE = "1";
    const MASTER_MODE_DISABLE = "0";
    const DB_KEY_MASTER = "configuration.cli.master";
    const DB_KEY_MASTER_SWITCHABLE = "configuration.cli.master_switchable";

    function __construct($cfg_xml_path)
    {
        $ms_db_info_retriever = new ManagementServerDBInfoRetriever($cfg_xml_path);
        $db_info = $ms_db_info_retriever->getDBInfo();
        $ms_ssh_cmd_retriever = new ManagementServerSSHCmdRetriever($cfg_xml_path);
        $management_server_ssh_cmd = $ms_ssh_cmd_retriever->getSSHCmd();
        $this->_db_cfg_mgr = new DatabaseConfigManager($db_info, $management_server_ssh_cmd);
    }

    public function enableMasterMode()
    {
        $this->setMasterMode(MasterModeConfiguration::MASTER_MODE_ENABLE);
    }

    public function disableMasterMode()
    {
        $this->setMasterMode(MasterModeConfiguration::MASTER_MODE_DISABLE);
    }

    protected function setMasterMode($master_mode)
    {
        $this->_db_cfg_mgr->setConfig(MasterModeConfiguration::DB_KEY_MASTER, $master_mode);
    }

    public function enableSwitchable()
    {
        $this->setSwitchable(MasterModeConfiguration::MASTER_SWITCHABLE_ENABLE);
    }

    public function disableSwitchable()
    {
        $this->setSwitchable(MasterModeConfiguration::MASTER_SWITCHABLE_DISABLE);
    }

    protected function setSwitchable($master_switchable)
    {
        $this->_db_cfg_mgr->setConfig(MasterModeConfiguration::DB_KEY_MASTER_SWITCHABLE, $master_switchable);
    }

    public function isMasterMode()
    {
        $this->_db_cfg_mgr->getConfig(MasterModeConfiguration::DB_KEY_MASTER, $master_mode);
        return $master_mode == MasterModeConfiguration::MASTER_MODE_ENABLE;
    }

    public function isSwitchable()
    {
        $this->_db_cfg_mgr->getConfig(MasterModeConfiguration::DB_KEY_MASTER_SWITCHABLE, $master_mode_switchable);
        return $master_mode_switchable == MasterModeConfiguration::MASTER_SWITCHABLE_ENABLE;
    }

    public function notifyConfigChange()
    {
        $this->_db_cfg_mgr->notifyConfigChange();
    }

}


